#include "mem.h"

/******************************************************************************/

void AllocateArray(unsigned char ****array, Exterior array_param)
{
  /*
  AllocateArray - allocates memory for array,
    where: array_param - set of parameters.
  For example: AllocateArray(array,array_param);
  */
  int slice, row, col;

  *array=(unsigned char ***)
         malloc(array_param.height*sizeof(unsigned char **));
  for(slice=0; slice<array_param.height; slice++)
  {
    (*array)[slice]=(unsigned char **)
                    malloc(array_param.length*sizeof(unsigned char *));
    for(row=0; row<array_param.length; row++)
      (*array)[slice][row]=(unsigned char *)
                           malloc(array_param.width*sizeof(unsigned char));
  }
  
  for (slice=0; slice<array_param.height; slice++)
    for (row=0; row<array_param.length; row++)
      for (col=0; col<array_param.width; col++)
        (*array)[slice][row][col]=0;

}


/******************************************************************************/

void FreeMemory(unsigned char ***array, Exterior array_param)
{
  /*
  FreeMemory - frees memory of array,
    where: array_param - set of parameters.
  For example: FreeMemory(array,array_param);
  */
  int slice, row;

  for(slice=0; slice<array_param.height; slice++)
    for(row=0; row<array_param.length; row++)
      free(array[slice][row]);

  for(slice=0; slice<array_param.height; slice++)
    free(array[slice]);

  free(array);

}
